
import gurobipy as gp

# Create a new model
model = gp.Model("CerealProduction")

# Create variables
nutritional = model.addVar(vtype=gp.GRB.CONTINUOUS, name="nutritional")
kids = model.addVar(vtype=gp.GRB.CONTINUOUS, name="kids")
sugary = model.addVar(vtype=gp.GRB.CONTINUOUS, name="sugary")


# Set objective function
model.setObjective(1 * nutritional + 1.5 * kids + 2 * sugary, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(3 * nutritional + 1.5 * kids + 2 * sugary <= 500, "oat_constraint")
model.addConstr(1 * nutritional + 1.5 * kids + 4 * sugary <= 700, "sugar_constraint")

# Non-negativity constraints are added implicitly by setting vtype to GRB.CONTINUOUS

# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Revenue: ${model.objVal:.2f}")
    print(f"Nutritional Cereal: {nutritional.x:.2f} boxes")
    print(f"Kids' Cereal: {kids.x:.2f} boxes")
    print(f"Sugary Cereal: {sugary.x:.2f} boxes")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

