
import gurobipy as gp

# Create a new model
model = gp.Model("Cereal_Production")

# Define the variables
x1 = model.addVar(name="nutritional_cereal", lb=0)
x2 = model.addVar(name="kids_cereal", lb=0)
x3 = model.addVar(name="sugary_cereal", lb=0)

# Define the objective function
model.setObjective(1*x1 + 1.5*x2 + 2*x3, gp.GRB.MAXIMIZE)

# Add the constraints
model.addConstr(3*x1 + 1.5*x2 + 2*x3 <= 500, name="oat_constraint")
model.addConstr(1*x1 + 1.5*x2 + 4*x3 <= 700, name="sugar_constraint")

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Nutritional Cereal: {x1.varValue}")
    print(f"Kids' Cereal: {x2.varValue}")
    print(f"Sugary Cereal: {x3.varValue}")
    print(f"Max Revenue: {model.objVal}")
else:
    print("The model is infeasible or unbounded.")
