
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("lighting_problem")

# Create variables
desk_lamps = m.addVar(vtype=GRB.INTEGER, name="desk_lamps")
chandeliers = m.addVar(vtype=GRB.INTEGER, name="chandeliers")

# Set objective function
m.setObjective(200 * desk_lamps + 500 * chandeliers, GRB.MAXIMIZE)

# Add constraints
m.addConstr(20 * desk_lamps + 60 * chandeliers <= 1500, "manufacturing_time")
m.addConstr(desk_lamps + 15 * chandeliers <= 300, "light_bulbs")
m.addConstr(desk_lamps >= 40, "min_desk_lamps")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of Desk Lamps: {desk_lamps.x}")
    print(f"Number of Chandeliers: {chandeliers.x}")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

