
from gurobipy import *

# Create a model
m = Model("Lighting_Company_Optimization")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="desk_lamps")
x2 = m.addVar(vtype=GRB.INTEGER, name="chandeliers")

# Set objective function
m.setObjective(200*x1 + 500*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(20*x1 + 60*x2 <= 1500, "manufacturing_time")
m.addConstr(x1 + 15*x2 <= 300, "light_bulbs")
m.addConstr(x1 >= 40, "minimum_desk_lamps")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: {x1.varName} = {x1.x}, {x2.varName} = {x2.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
