
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
x1 = model.addVar(lb=0, name="desk_lamps")  # Number of desk lamps
x2 = model.addVar(lb=0, name="chandeliers")  # Number of chandeliers

# Objective function: Maximize 200x1 + 500x2
model.setObjective(200 * x1 + 500 * x2, gurobi.GRB.MAXIMIZE)

# Constraints
model.addConstr(x1 >= 40, name="min_desk_lamps")  # At least 40 desk lamps
model.addConstr(20 * x1 + 60 * x2 <= 1500, name="manufacturing_time")  # Manufacturing time constraint
model.addConstr(x1 + 15 * x2 <= 300, name="light_bulbs")  # Light bulb constraint

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Desk lamps: {x1.varValue}")
    print(f"Chandeliers: {x2.varValue}")
    print(f"Max profit: {200 * x1.varValue + 500 * x2.varValue}")
else:
    print("No optimal solution found.")
