
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("investment_optimization")

# Create variables
video_game = m.addVar(lb=0, name="video_game")
camera = m.addVar(lb=0, name="camera")
cell_phone = m.addVar(lb=0, name="cell_phone")
laptop = m.addVar(lb=0, name="laptop")


# Set objective function
m.setObjective(0.07 * video_game + 0.03 * camera + 0.09 * cell_phone + 0.07 * laptop, GRB.MAXIMIZE)

# Add constraints
m.addConstr(video_game + camera + cell_phone + laptop <= 300000, "total_investment")
m.addConstr(laptop <= video_game, "laptop_vs_video_game")
m.addConstr(camera <= cell_phone, "camera_vs_cell_phone")
m.addConstr(laptop <= 0.15 * 300000, "laptop_investment_limit")


# Optimize model
m.optimize()

if m.status == GRB.OPTIMAL:
    print(f"Optimal objective value: {m.objVal}")
    print(f"Video Game Investment: {video_game.x}")
    print(f"Camera Investment: {camera.x}")
    print(f"Cell Phone Investment: {cell_phone.x}")
    print(f"Laptop Investment: {laptop.x}")

elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

