
import gurobipy as gp

# Create a new model
model = gp.Model("Investment_Problem")

# Define variables
x1 = model.addVar(name="video_game_company", lb=0)
x2 = model.addVar(name="camera_company", lb=0)
x3 = model.addVar(name="cell_phone_company", lb=0)
x4 = model.addVar(name="laptop_company", lb=0)

# Objective function: Maximize returns
model.setObjective(0.07*x1 + 0.03*x2 + 0.09*x3 + 0.07*x4, gp.GRB.MAXIMIZE)

# Constraints
model.addConstr(x1 + x2 + x3 + x4 <= 300000, name="total_investment")
model.addConstr(x4 <= x1, name="laptop_vs_video_game")
model.addConstr(x2 <= x3, name="camera_vs_cell_phone")
model.addConstr(x4 <= 45000, name="laptop_limit")

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
  print("Optimal Solution:")
  print(f"Video Game Company: ${x1.varValue:.2f}")
  print(f"Camera Company: ${x2.varValue:.2f}")
  print(f"Cell Phone Company: ${x3.varValue:.2f}")
  print(f"Laptop Company: ${x4.varValue:.2f}")
  print(f"Max Return: ${model.objVal:.2f}")
else:
  print("No optimal solution found.")
