
import gurobipy as gp

# Create a new model
m = gp.Model("investment_optimization")

# Create decision variables
film_investment = m.addVar(name="film_investment")
healthcare_investment = m.addVar(name="healthcare_investment")

# Set objective function
m.setObjective(0.08 * film_investment + 0.10 * healthcare_investment, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(film_investment + healthcare_investment <= 200000, "total_investment")
m.addConstr(film_investment >= 0.25 * (film_investment + healthcare_investment), "min_film_investment")
m.addConstr(healthcare_investment <= 0.60 * (film_investment + healthcare_investment), "max_healthcare_investment")
m.addConstr(film_investment >= 0, "non_negative_film")
m.addConstr(healthcare_investment >= 0, "non_negative_healthcare")


# Optimize the model
m.optimize()

# Print the results
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Film Investment: ${film_investment.x:.2f}")
    print(f"Healthcare Investment: ${healthcare_investment.x:.2f}")
    print(f"Total Return: ${m.objVal:.2f}")
else:
    print("No solution found.")

