
from gurobipy import *

# Create a model
m = Model("Investment_Optimization")

# Define variables
x1 = m.addVar(lb=0, name="film_investment")
x2 = m.addVar(lb=0, name="healthcare_investment")

# Set objective function
m.setObjective(0.08*x1 + 0.10*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 200000, "total_investment")
m.addConstr(x1 >= 50000, "min_film_investment")
m.addConstr(x2 <= 120000, "max_healthcare_investment")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print("Invest in film industry: $", x1.x)
    print("Invest in healthcare industry: $", x2.x)
    print("Maximum return: $", m.objVal)
else:
    print("No optimal solution found")
