
import gurobi

def solve_investment_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="film_investment", lb=0)
    x2 = model.addVar(name="healthcare_investment", lb=0)

    # Objective function: maximize 0.08*x1 + 0.10*x2
    model.setObjective(0.08 * x1 + 0.10 * x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x1 + x2 == 200000, name="total_investment")
    model.addConstr(x1 >= 0.25 * 200000, name="min_film_investment")
    model.addConstr(x2 <= 0.60 * 200000, name="max_healthcare_investment")

    # Solve the model
    model.optimize()

    # Print the results
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal investment in film industry: ", x1.varValue)
        print("Optimal investment in healthcare industry: ", x2.varValue)
        print("Maximum return on investment: ", model.objVal)
    else:
        print("The model is infeasible")

solve_investment_problem()
