
import gurobipy as gp

# Create a new model
m = gp.Model("Chocolate_Production")

# Create variables
bars = m.addVar(vtype=gp.GRB.INTEGER, name="bars")  # Number of chocolate bars
wafers = m.addVar(vtype=gp.GRB.INTEGER, name="wafers")  # Number of chocolate wafers


# Set objective function: Maximize profit
m.setObjective(2 * bars + 3 * wafers, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(bars <= 80, "Bar_Production_Limit")
m.addConstr(wafers <= 100, "Wafer_Production_Limit")
m.addConstr(bars + wafers <= 125, "Packaging_Limit")
m.addConstr(bars >=0, "Non_negative_bars")
m.addConstr(wafers >=0, "Non_negative_wafers")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found:")
    print(f"  Number of chocolate bars: {bars.x}")
    print(f"  Number of chocolate wafers: {wafers.x}")
    print(f"  Maximum profit: ${m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

