
from gurobipy import *

# Create a new model
m = Model("Chocolate_Production")

# Define variables
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="chocolate_bars")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="chocolate_wafers")

# Set the objective function
m.setObjective(2*x1 + 3*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 <= 80, "chocolate_bar_limit")
m.addConstr(x2 <= 100, "chocolate_wafer_limit")
m.addConstr(x1 + x2 <= 125, "packaging_machine_limit")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Chocolate bars: {x1.x}")
    print(f"Chocolate wafers: {x2.x}")
    print(f"Maximum profit: {m.objVal}")
else:
    print("No optimal solution found")
