
import gurobi

def solve_chocolate_production():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(lb=0, ub=80, name="chocolate_bars")
    x2 = model.addVar(lb=0, ub=100, name="chocolate_wafers")

    # Define the objective function
    model.setObjective(2*x1 + 3*x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(x1 <= 80, name="chocolate_bar_limit")
    model.addConstr(x2 <= 100, name="chocolate_wafer_limit")
    model.addConstr(x1 + x2 <= 125, name="packaging_machine_limit")

    # Optimize the model
    model.optimize()

    # Print the results
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Chocolate bars: {x1.varValue}")
        print(f"Chocolate wafers: {x2.varValue}")
        print(f"Max profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_chocolate_production()
