
import gurobipy as gp
from gurobipy import GRB

try:

    # Create a new model
    m = gp.Model("farm_optimization")

    # Create variables
    lavender = m.addVar(vtype=GRB.CONTINUOUS, name="lavender")
    tulips = m.addVar(vtype=GRB.CONTINUOUS, name="tulips")


    # Set objective
    m.setObjective(250 * lavender + 200 * tulips, GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(lavender + tulips <= 50, "Total_acres")
    m.addConstr(lavender >= 5, "Min_lavender")
    m.addConstr(tulips >= 8, "Min_tulips")
    m.addConstr(lavender <= 2 * tulips, "Lavender_tulip_ratio")



    # Optimize model
    m.optimize()

    if m.status == GRB.OPTIMAL:
        print('Optimal solution found:')
        print(f'Lavender: {lavender.x} acres')
        print(f'Tulips: {tulips.x} acres')
        print(f'Profit: ${m.objVal}')
    elif m.status == GRB.INFEASIBLE:
        print('Model is infeasible.')
    else:
        print(f'Optimization ended with status {m.status}.')


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
