
from gurobipy import *

# Create a new model
m = Model("Lavender_Tulips")

# Create variables
x1 = m.addVar(name='x1', lb=0)  # acres of lavender
x2 = m.addVar(name='x2', lb=0)  # acres of tulips

# Set the objective function
m.setObjective(250*x1 + 200*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 50, name='total_acres')
m.addConstr(x1 >= 5, name='min_lavender')
m.addConstr(x2 >= 8, name='min_tulips')
m.addConstr(x1 <= 2*x2, name='max_lavender_to_tulip_ratio')

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Acres of lavender: {x1.x}")
    print(f"Acres of tulips: {x2.x}")
    print(f"Maximum profit: ${250*x1.x + 200*x2.x:.2f}")
else:
    print("No optimal solution found")
