
import gurobipy as gp

# Create a new model
model = gp.Model("Gardener_Problem")

# Define the variables
x1 = model.addVar(name="lavender", lb=0)  # acres of lavender
x2 = model.addVar(name="tulips", lb=0)   # acres of tulips

# Objective function: Maximize profit
model.setObjective(250 * x1 + 200 * x2, gp.GRB.MAXIMIZE)

# Constraints
model.addConstr(x1 + x2 <= 50, name="total_acres")
model.addConstr(x1 >= 5, name="min_lavender")
model.addConstr(x2 >= 8, name="min_tulips")
model.addConstr(x1 <= 2 * x2, name="lavender_vs_tulips")

# Solve the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal acres of lavender: {x1.varValue}")
    print(f"Optimal acres of tulips: {x2.varValue}")
    print(f"Max Profit: ${250 * x1.varValue + 200 * x2.varValue}")
else:
    print("The model is infeasible.")
