
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("train_seating")

# Create variables
heated_seats = m.addVar(vtype=GRB.INTEGER, name="heated_seats")
regular_seats = m.addVar(vtype=GRB.INTEGER, name="regular_seats")

# Set objective function
m.setObjective(20 * heated_seats + 15 * regular_seats, GRB.MAXIMIZE)

# Add constraints
m.addConstr(heated_seats + regular_seats <= 100, "total_seats")
m.addConstr(heated_seats >= 15, "min_heated_seats")
m.addConstr(regular_seats >= 3 * heated_seats, "regular_preference")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal}")
    print(f"Number of heated seats: {heated_seats.x}")
    print(f"Number of regular seats: {regular_seats.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

