
from gurobipy import *

# Create a new model
m = Model("Train_Seat_Optimization")

# Create variables
x1 = m.addVar(name='heated_seats', vtype=GRB.INTEGER, lb=0)
x2 = m.addVar(name='regular_seats', vtype=GRB.INTEGER, lb=0)

# Set the objective function
m.setObjective(20*x1 + 15*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 100, name='total_seats')
m.addConstr(x1 >= 15, name='min_heated_seats')
m.addConstr(x2 >= 3*x1, name='regular_vs_heated')

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Heated seats: {x1.x}")
    print(f"Regular seats: {x2.x}")
    print(f"Maximum profit: {m.objVal}")
else:
    print("No optimal solution found")
