
import gurobi

def solve_train_seating_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="heated_seats", lb=0, ub=None)
    x2 = model.addVar(name="regular_seats", lb=0, ub=None)

    # Objective function: Maximize 20*x1 + 15*x2
    model.setObjective(20*x1 + 15*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x1 + x2 <= 100, name="total_seats")
    model.addConstr(x1 >= 15, name="min_heated_seats")
    model.addConstr(x2 >= 3*x1, name="regular_vs_heated")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: Heated seats = {x1.varValue}, Regular seats = {x2.varValue}")
    else:
        print("No optimal solution found")

solve_train_seating_problem()
