
import gurobipy as gp

# Create a new model
m = gp.Model("pharmacy_optimization")

# Create variables
pills = m.addVar(vtype=gp.GRB.CONTINUOUS, name="pills")  # Number of pill bottles
cream = m.addVar(vtype=gp.GRB.CONTINUOUS, name="cream")  # Number of cream bottles

# Set objective function
m.setObjective(50 * pills + 60 * cream, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(20 * pills + 15 * cream <= 4000, "weighing_time")
m.addConstr(10 * pills + 15 * cream <= 3000, "packaging_time")
m.addConstr(pills >= 0, "pills_nonnegative")
m.addConstr(cream >= 0, "cream_nonnegative")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal:.2f}")
    print(f"Number of pill bottles: {pills.x:.2f}")
    print(f"Number of cream bottles: {cream.x:.2f}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

