
from gurobipy import *

# Create a new model
m = Model("Pharmacy_Optimization")

# Define variables
x1 = m.addVar(name="bottles_of_pills", vtype=GRB.CONTINUOUS, lb=0)
x2 = m.addVar(name="bottles_of_cream", vtype=GRB.CONTINUOUS, lb=0)

# Set the objective function
m.setObjective(50*x1 + 60*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(20*x1 + 15*x2 <= 4000, name="weighing_time_constraint")
m.addConstr(10*x1 + 15*x2 <= 3000, name="packaging_time_constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of bottles of pills: {x1.x}")
    print(f"Number of bottles of cream: {x2.x}")
    print(f"Maximum profit: ${m.objVal}")
else:
    print("No optimal solution found")
