
import gurobipy as gp

# Create a new model
m = gp.Model("Pharmacy_Optimization")

# Define the variables
x1 = m.addVar(name="bottles_of_pills", lb=0, vtype=gp.GRB.INTEGER)
x2 = m.addVar(name="bottles_of_cream", lb=0, vtype=gp.GRB.INTEGER)

# Define the objective function
m.setObjective(50*x1 + 60*x2, gp.GRB.MAXIMIZE)

# Add the constraints
m.addConstr(20*x1 + 15*x2 <= 4000, name="weighing_constraint")
m.addConstr(10*x1 + 15*x2 <= 3000, name="packaging_constraint")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution: {x1.varName} = {x1.x}, {x2.varName} = {x2.x}")
    print(f"Maximum profit: ${50*x1.x + 60*x2.x:.2f}")
else:
    print("The model is infeasible.")
