
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Caviar_Production")

# Create variables
eastern = m.addVar(lb=0, name="eastern")  # Days per week eastern location operates
western = m.addVar(lb=0, name="western")  # Days per week western location operates


# Set objective function: Minimize total operating costs
m.setObjective(1000 * eastern + 2000 * western, GRB.MINIMIZE)

# Add constraints
m.addConstr(5 * eastern + 2 * western >= 25, "Cheap_Caviar")  # Cheap caviar production
m.addConstr(7 * eastern + 6 * western >= 35, "Regular_Caviar") # Regular caviar production
m.addConstr(1 * eastern + 4 * western >= 15, "Expensive_Caviar") # Expensive caviar production


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Eastern Location Operating Days: {eastern.x}")
    print(f"Western Location Operating Days: {western.x}")
    print(f"Minimum Cost: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

