
from gurobipy import *

# Create a model
m = Model("caviar_production")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="eastern_location_days")
x2 = m.addVar(vtype=GRB.INTEGER, name="western_location_days")

# Set the objective function
m.setObjective(1000*x1 + 2000*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(5*x1 + 2*x2 >= 25, "cheap_caviar_constraint")
m.addConstr(7*x1 + 6*x2 >= 35, "regular_caviar_constraint")
m.addConstr(x1 + 4*x2 >= 15, "expensive_caviar_constraint")
m.addConstr(x1 >= 0, "non_negative_eastern")
m.addConstr(x2 >= 0, "non_negative_western")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Eastern location operates for {x1.x} days")
    print(f"Western location operates for {x2.x} days")
else:
    print("No optimal solution found")
