
import gurobipy as gp

# Create a new model
model = gp.Model("Caviar_Production")

# Define variables
x1 = model.addVar(name="Eastern_Location_Days", lb=0, vtype=gp.GRB.INTEGER)
x2 = model.addVar(name="Western_Location_Days", lb=0, vtype=gp.GRB.INTEGER)

# Objective function: Minimize 1000x1 + 2000x2
model.setObjective(1000*x1 + 2000*x2, gp.GRB.MINIMIZE)

# Constraints
model.addConstr(5*x1 + 2*x2 >= 25, name="Cheap_Caviar_Constraint")
model.addConstr(7*x1 + 6*x2 >= 35, name="Regular_Caviar_Constraint")
model.addConstr(x1 + 4*x2 >= 15, name="Expensive_Caviar_Constraint")

# Solve the model
model.solve()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Eastern Location Days: {x1.varValue}")
    print(f"Western Location Days: {x2.varValue}")
    print(f"Objective Value: {model.objVal}")
else:
    print("No optimal solution found.")
