
import gurobipy as gp

# Create a new model
model = gp.Model("Candy_Combo_Optimization")

# Create decision variables
combo1 = model.addVar(vtype=gp.GRB.CONTINUOUS, name="combo1")
combo2 = model.addVar(vtype=gp.GRB.CONTINUOUS, name="combo2")


# Set objective function
model.setObjective(4 * combo1 + 4.5 * combo2, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(25 * combo1 + 12 * combo2 <= 1200, "gummy_bears_constraint")
model.addConstr(20 * combo1 + 21 * combo2 <= 1400, "gummy_worms_constraint")
model.addConstr(15 * combo1 + 24 * combo2 <= 900, "sour_candies_constraint")
model.addConstr(combo1 >=0)
model.addConstr(combo2 >=0)


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of Combo 1: {combo1.x}")
    print(f"Number of Combo 2: {combo2.x}")
    print(f"Maximum Profit: ${model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

