
from gurobipy import *

# Create a model
m = Model("Grocery_Store_Optimization")

# Define variables
x1 = m.addVar(name="Combo_1", vtype=GRB.CONTINUOUS, lb=0)
x2 = m.addVar(name="Combo_2", vtype=GRB.CONTINUOUS, lb=0)

# Set objective function
m.setObjective(4*x1 + 4.5*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(25*x1 + 12*x2 <= 1200, name="Gummy_Bears_Constraint")
m.addConstr(20*x1 + 21*x2 <= 1400, name="Gummy_Worms_Constraint")
m.addConstr(15*x1 + 24*x2 <= 900, name="Sour_Candies_Constraint")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Combo 1: {x1.x}")
    print(f"Combo 2: {x2.x}")
    print(f"Total Profit: ${4*x1.x + 4.5*x2.x:.2f}")
else:
    print("No optimal solution found.")
