
import gurobi

def solve_combo_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(lb=0, name="Combo_1")
    x2 = model.addVar(lb=0, name="Combo_2")

    # Objective function: Maximize profit
    model.setObjective(4 * x1 + 4.50 * x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(25 * x1 + 12 * x2 <= 1200, name="Gummy_Bears_Constraint")
    model.addConstr(20 * x1 + 21 * x2 <= 1400, name="Gummy_Worms_Constraint")
    model.addConstr(15 * x1 + 24 * x2 <= 900, name="Sour_Candies_Constraint")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: Combo 1 = {x1.varValue}, Combo 2 = {x2.varValue}")
        print(f"Maximum profit: ${model.objVal:.2f}")
    else:
        print("No optimal solution found.")

solve_combo_problem()
