
import gurobipy as gp

# Create a new model
model = gp.Model("Paper_Production")

# Create variables
lined_paper = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="lined_paper")
graph_paper = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="graph_paper")


# Set objective function
model.setObjective(11 * lined_paper + 13 * graph_paper, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(2 * lined_paper + 2 * graph_paper <= 3500, "cutting_constraint")
model.addConstr(6 * lined_paper + 10 * graph_paper <= 3500, "printing_constraint")


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Lined Paper: {lined_paper.x}")
    print(f"Graph Paper: {graph_paper.x}")
    print(f"Profit: ${model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

