
from gurobipy import *

# Create a new model
m = Model("Paper_Company_Optimization")

# Define variables
x1 = m.addVar(lb=0, name="lined_paper")
x2 = m.addVar(lb=0, name="graph_paper")

# Set the objective function
m.setObjective(11*x1 + 13*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(2*x1 + 2*x2 <= 3500, "cutting_machine")
m.addConstr(6*x1 + 10*x2 <= 3500, "line_printing_machine")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of reams of lined paper: {x1.x}")
    print(f"Number of reams of graph paper: {x2.x}")
    print(f"Maximum profit: ${m.objVal:.2f}")
else:
    print("No optimal solution found")
