
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="lined_paper", lb=0, ub=gurobi.GRB.INFINITY)
    x2 = model.addVar(name="graph_paper", lb=0, ub=gurobi.GRB.INFINITY)

    # Objective function: Maximize profit
    model.setObjective(11*x1 + 13*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(2*x1 + 2*x2 <= 3500, name="cutting_machine_constraint")
    model.addConstr(6*x1 + 10*x2 <= 3500, name="line_printing_machine_constraint")

    # Solve the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Lined Paper: {x1.varValue}")
        print(f"Graph Paper: {x2.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("The model is infeasible or unbounded.")

solve_optimization_problem()
