
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("chair_production")

# Create variables
desk_chairs = m.addVar(vtype=GRB.INTEGER, name="desk_chairs")
garden_chairs = m.addVar(vtype=GRB.INTEGER, name="garden_chairs")

# Set objective function
m.setObjective(100 * desk_chairs + 150 * garden_chairs, GRB.MAXIMIZE)

# Add constraints
m.addConstr(200 * desk_chairs + 300 * garden_chairs <= 35000, "budget_constraint")
m.addConstr(desk_chairs + garden_chairs <= 250, "demand_constraint")
m.addConstr(desk_chairs >= 0, "desk_nonnegativity")
m.addConstr(garden_chairs >= 0, "garden_nonnegativity")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of Desk Chairs: {desk_chairs.x}")
    print(f"Number of Garden Chairs: {garden_chairs.x}")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

