
from gurobipy import *

# Create a new model
m = Model("Nova_Furniture")

# Define the variables
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="desk_chairs")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="garden_chairs")

# Set the objective function
m.setObjective(100*x1 + 150*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 250, "demand_limit")
m.addConstr(200*x1 + 300*x2 <= 35000, "budget_limit")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of desk chairs: {x1.x}")
    print(f"Number of garden chairs: {x2.x}")
    print(f"Total profit: {m.objVal}")
else:
    print("No optimal solution found")
