
import gurobi

def solve_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="desk_chairs", lb=0, ub=None, obj=100)
    x2 = model.addVar(name="garden_chairs", lb=0, ub=None, obj=150)

    # Add constraints
    model.addConstr(x1 + x2 <= 250, name="demand_constraint")
    model.addConstr(200*x1 + 300*x2 <= 35000, name="budget_constraint")

    # Set the model objective
    model.setObjective(x1.obj * x1.varName + x2.obj * x2.varName, gurobi.GRB.MAXIMIZE)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Desk chairs: {x1.x}")
        print(f"Garden chairs: {x2.x}")
        print(f"Maximum profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_problem()
