
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("video_game_profit")

# Create variables
consoles = m.addVar(lb=0, vtype=GRB.INTEGER, name="consoles")
discs = m.addVar(lb=0, vtype=GRB.INTEGER, name="discs")

# Set objective function
m.setObjective(200 * consoles + 30 * discs, GRB.MAXIMIZE)

# Add constraints
m.addConstr(300 * consoles + 30 * discs <= 30000, "budget")
m.addConstr(consoles >= 20, "min_consoles")
m.addConstr(consoles <= 50, "max_consoles")
m.addConstr(discs <= 5 * consoles, "disc_limit")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal}")
    print(f"Number of consoles to sell: {consoles.x}")
    print(f"Number of discs to sell: {discs.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

