
from gurobipy import *

# Create a new model
m = Model("Video_Game_Store")

# Define variables
x1 = m.addVar(name='consoles', vtype=GRB.INTEGER)
x2 = m.addVar(name='discs', vtype=GRB.INTEGER)

# Set objective function
m.setObjective(200*x1 + 30*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(300*x1 + 30*x2 <= 30000, name='budget')
m.addConstr(x1 >= 20, name='min_consoles')
m.addConstr(x1 <= 50, name='max_consoles')
m.addConstr(x2 <= 5*x1, name='discs_vs_consoles')

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Consoles: {x1.x}")
    print(f"Discs: {x2.x}")
    print(f"Max Profit: {m.objVal}")
else:
    print("No optimal solution found")
