
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(lb=0, ub=50, vtype=gurobi.GRB.INTEGER, name="consoles")
    x2 = model.addVar(lb=0, vtype=gurobi.GRB.INTEGER, name="discs")

    # Objective function: maximize profit
    model.setObjective(200*x1 + 30*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(300*x1 + 30*x2 <= 30000, name="budget_constraint")
    model.addConstr(x1 >= 20, name="min_consoles_constraint")
    model.addConstr(x2 <= 5*x1, name="discs_to_consoles_ratio_constraint")

    # Solve the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Consoles: {x1.varValue}")
        print(f"Discs: {x2.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("The model is infeasible or unbounded.")

solve_optimization_problem()
