
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Minimize Cost")

# Create variables
elk = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="elk") # Servings of elk meat
bison = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="bison") # Servings of bison meat


# Set objective function: Minimize cost
m.setObjective(6 * elk + 7 * bison, GRB.MINIMIZE)

# Add constraints
m.addConstr(5 * elk + 4 * bison >= 30, "IronRequirement") # Iron constraint
m.addConstr(3 * elk + 4 * bison >= 40, "ZincRequirement") # Zinc constraint


# Optimize model
m.optimize()

# Check for infeasibility
if m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    # Print optimal solution
    print(f"Optimal Cost: ${m.objVal}")
    print(f"Servings of Elk Meat: {elk.x}")
    print(f"Servings of Bison Meat: {bison.x}")

