
from gurobipy import *

# Create a new model
m = Model("Nutrition_Optimization")

# Define variables
x1 = m.addVar(name='x1', lb=0)
x2 = m.addVar(name='x2', lb=0)

# Set the objective function
m.setObjective(6*x1 + 7*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(5*x1 + 4*x2 >= 30, name='Iron_Requirement')
m.addConstr(3*x1 + 4*x2 >= 40, name='Zinc_Requirement')

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found: x1 = {x1.x}, x2 = {x2.x}")
    print(f"Total cost: {6*x1.x + 7*x2.x}")
else:
    print("No optimal solution found")
