
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="elk_meat", lb=0)
    x2 = model.addVar(name="bison_meat", lb=0)

    # Define the objective function
    model.setObjective(6 * x1 + 7 * x2, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(5 * x1 + 4 * x2 >= 30, name="iron_constraint")
    model.addConstr(3 * x1 + 4 * x2 >= 40, name="zinc_constraint")

    # Optimize the model
    model.optimize()

    # Print the status
    if model.status == gurobi.GRB.Status.OPTIMAL:
        print("Optimal solution found.")
        print(f"Elk meat servings: {x1.varValue}")
        print(f"Bison meat servings: {x2.varValue}")
        print(f"Total cost: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
