
import gurobipy as gp

# Create a new model
m = gp.Model("violin_production")

# Create variables
modern = m.addVar(vtype=gp.GRB.CONTINUOUS, name="modern")  # Number of modern violins
baroque = m.addVar(vtype=gp.GRB.CONTINUOUS, name="baroque")  # Number of baroque violins


# Set objective function
m.setObjective(150 * modern + 200 * baroque, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(5 * modern + 4 * baroque <= 150, "woodworking_time")
m.addConstr(3.5 * modern + 5 * baroque <= 200, "assembling_time")
m.addConstr(modern >=0)
m.addConstr(baroque >=0)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"  Modern Violins: {modern.x}")
    print(f"  Baroque Violins: {baroque.x}")
    print(f"  Maximum Profit: ${m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

