
from gurobipy import *

# Create a new model
m = Model("Violin_Factory")

# Define variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="modern_violins", lb=0)
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="baroque_violins", lb=0)

# Set objective function
m.setObjective(150*x1 + 200*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(5*x1 + 4*x2 <= 150, "woodworking_time")
m.addConstr(3.5*x1 + 5*x2 <= 200, "assembling_time")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: {x1.varName} = {x1.x}, {x2.varName} = {x2.x}")
    print(f"Maximum profit: {m.objVal}")
else:
    print("No optimal solution found")
