
import gurobipy as gp

# Create a new model
model = gp.Model("Violin_Factory_Optimization")

# Define variables
x1 = model.addVar(name="modern_violins", lb=0, vtype=gp.GRB.CONTINUOUS)
x2 = model.addVar(name="baroque_violins", lb=0, vtype=gp.GRB.CONTINUOUS)

# Objective function: Maximize profit
model.setObjective(150*x1 + 200*x2, gp.GRB.MAXIMIZE)

# Constraints
model.addConstr(5*x1 + 4*x2 <= 150, name="woodworking_time")
model.addConstr(3.5*x1 + 5*x2 <= 200, name="assembling_time")

# Solve the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution: {model.x[0].varName} = {model.x[0].x}, {model.x[1].varName} = {model.x[1].x}")
    print(f"Max Profit: ${model.objVal:.2f}")
else:
    print("No optimal solution found.")
