
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("flooring_optimization")

# Create variables
hardwood = m.addVar(vtype=GRB.CONTINUOUS, name="hardwood")
carpet = m.addVar(vtype=GRB.CONTINUOUS, name="carpet")


# Set objective function
m.setObjective(400 * hardwood + 650 * carpet, GRB.MAXIMIZE)

# Add constraints
m.addConstr(1 * hardwood + 0.5 * carpet <= 200, "cutting_constraint")
m.addConstr(3 * hardwood + 4 * carpet <= 400, "installation_constraint")
m.addConstr(hardwood >= 0, "hardwood_nonnegative")
m.addConstr(carpet >= 0, "carpet_nonnegative")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal}")
    print(f"Hardwood flooring: {hardwood.x}")
    print(f"Carpet: {carpet.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

