
from gurobipy import *

# Create a new model
m = Model("Flooring_Installation")

# Create variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="hardwood_floorings", lb=0)
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="carpets", lb=0)

# Set the objective function
m.setObjective(400*x1 + 650*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + 0.5*x2 <= 200, "cutting_hours")
m.addConstr(3*x1 + 4*x2 <= 400, "installation_hours")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hardwood floorings: {x1.x}")
    print(f"Carpets: {x2.x}")
    print(f"Total profit: ${400*x1.x + 650*x2.x:.2f}")
else:
    print("No optimal solution found")
