
import gurobi as gp

# Create a new model
m = gp.Model()

# Define the variables
x1 = m.addVar(name="hardwood_flooring", lb=0, vtype=gp.GRB.CONTINUOUS)
x2 = m.addVar(name="carpet", lb=0, vtype=gp.GRB.CONTINUOUS)

# Define the objective function
m.setObjective(400*x1 + 650*x2, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + 0.5*x2 <= 200, name="cutting_constraint")
m.addConstr(3*x1 + 4*x2 <= 400, name="installation_constraint")

# Optimize the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Hardwood flooring: {x1.varValue}")
    print(f"Carpet: {x2.varValue}")
    print(f"Max Profit: {m.objVal}")
else:
    print("No optimal solution found.")
