
import gurobipy as gp

# Create a new model
model = gp.Model("WeddingCakeMix")

# Create variables
vanilla = model.addVar(lb=0, name="vanilla")  # kg of vanilla cake mix
chocolate = model.addVar(lb=0, name="chocolate") # kg of chocolate cake mix

# Set objective function
model.setObjective(10 * vanilla + 15 * chocolate, gp.GRB.MINIMIZE)

# Add constraints
model.addConstr(0.03 * vanilla + 0.02 * chocolate >= 0.3, "LeaveningAgent")
model.addConstr(0.55 * vanilla + 0.43 * chocolate >= 10, "Flour")


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal cost: ${model.objVal:.2f}")
    print(f"Vanilla cake mix: {vanilla.x:.2f} kg")
    print(f"Chocolate cake mix: {chocolate.x:.2f} kg")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

