
from gurobipy import *

# Create a new model
m = Model("Wedding_Cake_Optimization")

# Define variables
x1 = m.addVar(lb=0, name="vanilla_cake_mix")
x2 = m.addVar(lb=0, name="chocolate_cake_mix")

# Set the objective function
m.setObjective(10*x1 + 15*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(0.03*x1 + 0.02*x2 >= 0.3, "leavening_agent_constraint")
m.addConstr(0.55*x1 + 0.43*x2 >= 10, "flour_constraint")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Vanilla cake mix: {x1.x} kg")
    print(f"Chocolate cake mix: {x2.x} kg")
    print(f"Total cost: ${m.objVal}")
else:
    print("No optimal solution found")
