
import gurobi

def solve_wedding_cake_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="vanilla_cake_mix", lb=0, ub=gurobi.GRB.INFINITY)
    x2 = model.addVar(name="chocolate_cake_mix", lb=0, ub=gurobi.GRB.INFINITY)

    # Objective function: minimize 10*x1 + 15*x2
    model.setObjective(10*x1 + 15*x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(0.03*x1 + 0.02*x2 >= 0.3, name="leavening_agent")
    model.addConstr(0.55*x1 + 0.43*x2 >= 10, name="flour")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Vanilla cake mix: {x1.varValue} kg")
        print(f"Chocolate cake mix: {x2.varValue} kg")
        print(f"Optimal cost: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_wedding_cake_problem()
