
import gurobipy as gp

# Create a new model
model = gp.Model("Snack Mix Optimization")

# Create variables
x1 = model.addVar(vtype=gp.GRB.CONTINUOUS, name="snack_mix_A")  # Number of snack mix A
x2 = model.addVar(vtype=gp.GRB.CONTINUOUS, name="snack_mix_B")  # Number of snack mix B


# Set objective function
model.setObjective(1.00 * x1 + 1.20 * x2, gp.GRB.MINIMIZE)

# Add constraints
model.addConstr(20 * x1 + 10 * x2 >= 90, "cashews_constraint")
model.addConstr(30 * x1 + 45 * x2 >= 80, "peanuts_constraint")
model.addConstr(x1 <= 12, "snack_mix_A_limit")
model.addConstr(x1 >= 0, "snack_mix_A_nonnegative")  # Ensure non-negative quantities
model.addConstr(x2 >= 0, "snack_mix_B_nonnegative")  # Ensure non-negative quantities


# Optimize the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found. Cost: ${model.objVal:.2f}")
    print(f"Number of Snack Mix A: {x1.x:.2f}")
    print(f"Number of Snack Mix B: {x2.x:.2f}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

